using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Web.Mvc;
using HIPS.Web.UI.ViewModels.Shared;

namespace HIPS.Web.UI.ViewModels.HpiiSearch
{
    public class SearchResultViewModel
    {
        #region Properties

        [Display(Name = "Organisation (HPI-O)")]
        public string Hpio { get; set; }

        [Display(Name = "HPI-I")]
        public string Hpii { get; set; }

        [Display(Name = "HPI-I Status")]
        public string HpiiStatus { get; set; }

        [Display(Name = "Registration ID (AHPRA)")]
        public string RegistrationId { get; set; }

        [Display(Name = "Family Name")]
        public string FamilyName { get; set; }

        [Display(Name = "Given Name(s)")]
        public string GivenNames { get; set; }

        [Display(Name = "Sex")]
        public string SexCode { get; set; }

        [Display(Name = "Date of Birth"), DisplayFormat(DataFormatString = "dd/MM/yyyy")]
        public DateTime? DateOfBirth { get; set; }

        [Display(Name = "State")]
        public string StateCode { get; set; }

        [Display(Name = "Postcode")]
        public string Postcode { get; set; }

        public AustralianAddressViewModel AustralianAddress { get; set; }

        public InternationalAddressViewModel InternationalAddress { get; set; }

        public ResponseMessages ResponseMessages { get; internal set; }

        #endregion

        #region Data Source Properties

        public IEnumerable<SelectListItem> Hpios { get; internal set; }
        public IEnumerable<SelectListItem> Sexes { get; internal set; }

        public IEnumerable<SelectListItem> UnitTypes
        {
            get { return AustralianAddress.UnitTypes; }
            internal set { AustralianAddress.UnitTypes = value; }
        }

        public IEnumerable<SelectListItem> LevelTypes
        {
            get { return AustralianAddress.LevelTypes; }
            internal set { AustralianAddress.LevelTypes = value; }
        }

        public IEnumerable<SelectListItem> StreetTypes
        {
            get { return AustralianAddress.StreetTypes; }
            internal set { AustralianAddress.StreetTypes = value; }
        }

        public IEnumerable<SelectListItem> StreetSuffixes
        {
            get { return AustralianAddress.StreetSuffixes; }
            internal set { AustralianAddress.StreetSuffixes = value; }
        }

        public IEnumerable<SelectListItem> PostalDeliveryTypes
        {
            get { return AustralianAddress.PostalDeliveryTypes; }
            internal set { AustralianAddress.PostalDeliveryTypes = value; }
        }

        public IEnumerable<SelectListItem> States
        {
            get { return AustralianAddress.States; }
            internal set { AustralianAddress.States = value; }
        }

        public IEnumerable<SelectListItem> Countries
        {
            get { return InternationalAddress.Countries; }
            internal set { InternationalAddress.Countries = value; }
        }

        #endregion

        #region View Logic Properties

        public bool ShowAustralianAddress { get; internal set; }
        public bool ShowInternationalAddress { get; internal set; }

        #endregion

        public SearchResultViewModel()
        {
            AustralianAddress = new AustralianAddressViewModel();
            InternationalAddress = new InternationalAddressViewModel();
            ResponseMessages = new ResponseMessages();
            Hpios = Enumerable.Empty<SelectListItem>();
            Sexes = Enumerable.Empty<SelectListItem>();
            ShowAustralianAddress = true;
            ShowInternationalAddress = true;
        }
    }
}